/*******************************************************************************
 * 
 * Ex8.cs
 *
 * Copyright (c) 2005 Alien Technology Corporation.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1)	Redistributions of source code must retain the above copyright 
 *		notice, this list of conditions and the following disclaimer. 
 *
 * 2)	Redistributions in binary form must reproduce the above copyright 
 *		notice, this list of conditions and the following disclaimer 
 *		in the documentation and/or other materials provided with the distribution. 
 *
 * 3)	Neither the name of Alien Technology Corporation nor the names of any 
 *		contributors may be used to endorse or promote products derived from this 
 *		software without specific prior written permission. 
 *
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 *	AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 *	IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *	ARE DISCLAIMED. IN NO EVENT SHALL ALIEN TECHNOLOGY CORPORATION OR ITS 
 *	CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 *	EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 *	PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 *	OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 *	WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 *	OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 *	OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *  Abstract:
 *		This file contains a Windows example application code utilizing Alien .NET API.
 *		To run this program with an Alien reader connect the reader's IO port to a device
 *		that has 4 output lights and 4 input switches.
 *
 ***********************************************************************************/


using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Threading;

using nsAlienRFID2;


namespace Ex1cs
{
	public class Form1 : System.Windows.Forms.Form
	{

		private clsReader mReader;
		private ReaderInfo mReaderInfo;
		private ComInterface meReaderInterface = ComInterface.enumTCPIP;

		private int mOutputValue;
		private int mInputValue;		

		#region Auto-generated code

		private System.Windows.Forms.Button btnConnect;
		private System.Windows.Forms.Button btnDisconnect;
		private System.Windows.Forms.GroupBox groupOutput;
		private System.Windows.Forms.Label lblOutput;
		private System.Windows.Forms.CheckBox chkOutput0;
		private System.Windows.Forms.CheckBox chkOutput1;
		private System.Windows.Forms.CheckBox chkOutput2;
		private System.Windows.Forms.CheckBox chkOutput3;
		private System.Windows.Forms.GroupBox groupInput;
		private System.Windows.Forms.CheckBox chkInput2;
		private System.Windows.Forms.CheckBox chkInput0;
		private System.Windows.Forms.CheckBox chkInput3;
		private System.Windows.Forms.CheckBox chkInput1;
		private System.Windows.Forms.Label lblInput;
		private System.Windows.Forms.GroupBox grpConnection;
		private System.Windows.Forms.RadioButton rdoSerial;
		private System.Windows.Forms.RadioButton rdoTCP;
		private System.Windows.Forms.GroupBox grpNetwork;
		private System.Windows.Forms.TextBox textBox1;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.NumericUpDown PortUD;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.GroupBox grpSerial;
		private System.Windows.Forms.NumericUpDown udRequestTimeout;
		private System.Windows.Forms.ComboBox cboSerialPorts;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.GroupBox grpStatus;
		private System.Windows.Forms.Label lblStatus;
		private System.Windows.Forms.Timer timer1;
		internal System.Windows.Forms.Label Label7;
		internal System.Windows.Forms.Label Label6;
		internal System.Windows.Forms.Label Label2;
		internal System.Windows.Forms.Label Label1;
		internal System.Windows.Forms.Label label9;
		internal System.Windows.Forms.Label label10;
		internal System.Windows.Forms.Label label11;
		internal System.Windows.Forms.Label label12;
		internal System.Windows.Forms.Label label13;
		internal System.Windows.Forms.Label label14;
		internal System.Windows.Forms.Label Label15;
		private System.Windows.Forms.ComboBox cboHostBaudRate;
		private System.Windows.Forms.Label label16;
		private System.ComponentModel.IContainer components;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            this.btnConnect = new System.Windows.Forms.Button();
            this.btnDisconnect = new System.Windows.Forms.Button();
            this.chkOutput0 = new System.Windows.Forms.CheckBox();
            this.chkOutput1 = new System.Windows.Forms.CheckBox();
            this.chkOutput2 = new System.Windows.Forms.CheckBox();
            this.chkOutput3 = new System.Windows.Forms.CheckBox();
            this.groupOutput = new System.Windows.Forms.GroupBox();
            this.label13 = new System.Windows.Forms.Label();
            this.label9 = new System.Windows.Forms.Label();
            this.label10 = new System.Windows.Forms.Label();
            this.label11 = new System.Windows.Forms.Label();
            this.label12 = new System.Windows.Forms.Label();
            this.lblOutput = new System.Windows.Forms.Label();
            this.groupInput = new System.Windows.Forms.GroupBox();
            this.label14 = new System.Windows.Forms.Label();
            this.Label7 = new System.Windows.Forms.Label();
            this.Label6 = new System.Windows.Forms.Label();
            this.Label2 = new System.Windows.Forms.Label();
            this.Label1 = new System.Windows.Forms.Label();
            this.chkInput2 = new System.Windows.Forms.CheckBox();
            this.chkInput0 = new System.Windows.Forms.CheckBox();
            this.chkInput3 = new System.Windows.Forms.CheckBox();
            this.chkInput1 = new System.Windows.Forms.CheckBox();
            this.lblInput = new System.Windows.Forms.Label();
            this.grpConnection = new System.Windows.Forms.GroupBox();
            this.rdoSerial = new System.Windows.Forms.RadioButton();
            this.rdoTCP = new System.Windows.Forms.RadioButton();
            this.udRequestTimeout = new System.Windows.Forms.NumericUpDown();
            this.label5 = new System.Windows.Forms.Label();
            this.grpNetwork = new System.Windows.Forms.GroupBox();
            this.textBox1 = new System.Windows.Forms.TextBox();
            this.label3 = new System.Windows.Forms.Label();
            this.PortUD = new System.Windows.Forms.NumericUpDown();
            this.label4 = new System.Windows.Forms.Label();
            this.grpSerial = new System.Windows.Forms.GroupBox();
            this.cboHostBaudRate = new System.Windows.Forms.ComboBox();
            this.label16 = new System.Windows.Forms.Label();
            this.cboSerialPorts = new System.Windows.Forms.ComboBox();
            this.label8 = new System.Windows.Forms.Label();
            this.grpStatus = new System.Windows.Forms.GroupBox();
            this.lblStatus = new System.Windows.Forms.Label();
            this.timer1 = new System.Windows.Forms.Timer(this.components);
            this.Label15 = new System.Windows.Forms.Label();
            this.groupOutput.SuspendLayout();
            this.groupInput.SuspendLayout();
            this.grpConnection.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.udRequestTimeout)).BeginInit();
            this.grpNetwork.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.PortUD)).BeginInit();
            this.grpSerial.SuspendLayout();
            this.grpStatus.SuspendLayout();
            this.SuspendLayout();
            // 
            // btnConnect
            // 
            this.btnConnect.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.btnConnect.Location = new System.Drawing.Point(226, 50);
            this.btnConnect.Name = "btnConnect";
            this.btnConnect.Size = new System.Drawing.Size(127, 27);
            this.btnConnect.TabIndex = 3;
            this.btnConnect.Text = "&Connect";
            this.btnConnect.UseVisualStyleBackColor = false;
            this.btnConnect.Click += new System.EventHandler(this.btnConnect_Click);
            // 
            // btnDisconnect
            // 
            this.btnDisconnect.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.btnDisconnect.Location = new System.Drawing.Point(225, 153);
            this.btnDisconnect.Name = "btnDisconnect";
            this.btnDisconnect.Size = new System.Drawing.Size(127, 28);
            this.btnDisconnect.TabIndex = 13;
            this.btnDisconnect.Text = "&Disconnect";
            this.btnDisconnect.UseVisualStyleBackColor = false;
            this.btnDisconnect.Click += new System.EventHandler(this.btnDisconnect_Click);
            // 
            // chkOutput0
            // 
            this.chkOutput0.Appearance = System.Windows.Forms.Appearance.Button;
            this.chkOutput0.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.chkOutput0.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(64)))), ((int)(((byte)(0)))), ((int)(((byte)(64)))));
            this.chkOutput0.Location = new System.Drawing.Point(198, 40);
            this.chkOutput0.Name = "chkOutput0";
            this.chkOutput0.Size = new System.Drawing.Size(24, 24);
            this.chkOutput0.TabIndex = 14;
            this.chkOutput0.Text = "0";
            this.chkOutput0.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.chkOutput0.UseVisualStyleBackColor = false;
            this.chkOutput0.CheckedChanged += new System.EventHandler(this.chkOutputs_CheckedChanged);
            // 
            // chkOutput1
            // 
            this.chkOutput1.Appearance = System.Windows.Forms.Appearance.Button;
            this.chkOutput1.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.chkOutput1.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(64)))), ((int)(((byte)(0)))), ((int)(((byte)(64)))));
            this.chkOutput1.Location = new System.Drawing.Point(143, 40);
            this.chkOutput1.Name = "chkOutput1";
            this.chkOutput1.Size = new System.Drawing.Size(24, 24);
            this.chkOutput1.TabIndex = 15;
            this.chkOutput1.Text = "0";
            this.chkOutput1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.chkOutput1.UseVisualStyleBackColor = false;
            this.chkOutput1.CheckedChanged += new System.EventHandler(this.chkOutputs_CheckedChanged);
            // 
            // chkOutput2
            // 
            this.chkOutput2.Appearance = System.Windows.Forms.Appearance.Button;
            this.chkOutput2.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.chkOutput2.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(64)))), ((int)(((byte)(0)))), ((int)(((byte)(64)))));
            this.chkOutput2.Location = new System.Drawing.Point(88, 40);
            this.chkOutput2.Name = "chkOutput2";
            this.chkOutput2.Size = new System.Drawing.Size(24, 24);
            this.chkOutput2.TabIndex = 16;
            this.chkOutput2.Text = "0";
            this.chkOutput2.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.chkOutput2.UseVisualStyleBackColor = false;
            this.chkOutput2.CheckedChanged += new System.EventHandler(this.chkOutputs_CheckedChanged);
            // 
            // chkOutput3
            // 
            this.chkOutput3.Appearance = System.Windows.Forms.Appearance.Button;
            this.chkOutput3.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.chkOutput3.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(64)))), ((int)(((byte)(0)))), ((int)(((byte)(64)))));
            this.chkOutput3.Location = new System.Drawing.Point(33, 40);
            this.chkOutput3.Name = "chkOutput3";
            this.chkOutput3.Size = new System.Drawing.Size(24, 24);
            this.chkOutput3.TabIndex = 17;
            this.chkOutput3.Text = "0";
            this.chkOutput3.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.chkOutput3.UseVisualStyleBackColor = false;
            this.chkOutput3.CheckedChanged += new System.EventHandler(this.chkOutputs_CheckedChanged);
            // 
            // groupOutput
            // 
            this.groupOutput.Controls.Add(this.label13);
            this.groupOutput.Controls.Add(this.label9);
            this.groupOutput.Controls.Add(this.label10);
            this.groupOutput.Controls.Add(this.label11);
            this.groupOutput.Controls.Add(this.label12);
            this.groupOutput.Controls.Add(this.chkOutput2);
            this.groupOutput.Controls.Add(this.chkOutput0);
            this.groupOutput.Controls.Add(this.chkOutput3);
            this.groupOutput.Controls.Add(this.chkOutput1);
            this.groupOutput.Controls.Add(this.lblOutput);
            this.groupOutput.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.groupOutput.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.groupOutput.Location = new System.Drawing.Point(296, 181);
            this.groupOutput.Name = "groupOutput";
            this.groupOutput.Size = new System.Drawing.Size(256, 112);
            this.groupOutput.TabIndex = 18;
            this.groupOutput.TabStop = false;
            this.groupOutput.Text = "External Outputs";
            // 
            // label13
            // 
            this.label13.Font = new System.Drawing.Font("Microsoft Sans Serif", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label13.Location = new System.Drawing.Point(68, 80);
            this.label13.Name = "label13";
            this.label13.Size = new System.Drawing.Size(40, 16);
            this.label13.TabIndex = 28;
            this.label13.Text = "Value:";
            // 
            // label9
            // 
            this.label9.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label9.Location = new System.Drawing.Point(33, 24);
            this.label9.Name = "label9";
            this.label9.Size = new System.Drawing.Size(32, 16);
            this.label9.TabIndex = 27;
            this.label9.Text = "Pin 3";
            // 
            // label10
            // 
            this.label10.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label10.Location = new System.Drawing.Point(89, 24);
            this.label10.Name = "label10";
            this.label10.Size = new System.Drawing.Size(32, 16);
            this.label10.TabIndex = 26;
            this.label10.Text = "Pin 2";
            // 
            // label11
            // 
            this.label11.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label11.Location = new System.Drawing.Point(145, 24);
            this.label11.Name = "label11";
            this.label11.Size = new System.Drawing.Size(32, 16);
            this.label11.TabIndex = 25;
            this.label11.Text = "Pin 1";
            // 
            // label12
            // 
            this.label12.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label12.Location = new System.Drawing.Point(201, 24);
            this.label12.Name = "label12";
            this.label12.Size = new System.Drawing.Size(32, 16);
            this.label12.TabIndex = 24;
            this.label12.Text = "Pin 0";
            // 
            // lblOutput
            // 
            this.lblOutput.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblOutput.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.lblOutput.Location = new System.Drawing.Point(110, 80);
            this.lblOutput.Name = "lblOutput";
            this.lblOutput.Size = new System.Drawing.Size(40, 16);
            this.lblOutput.TabIndex = 19;
            this.lblOutput.Text = "0";
            this.lblOutput.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // groupInput
            // 
            this.groupInput.Controls.Add(this.label14);
            this.groupInput.Controls.Add(this.Label7);
            this.groupInput.Controls.Add(this.Label6);
            this.groupInput.Controls.Add(this.Label2);
            this.groupInput.Controls.Add(this.Label1);
            this.groupInput.Controls.Add(this.chkInput2);
            this.groupInput.Controls.Add(this.chkInput0);
            this.groupInput.Controls.Add(this.chkInput3);
            this.groupInput.Controls.Add(this.chkInput1);
            this.groupInput.Controls.Add(this.lblInput);
            this.groupInput.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.groupInput.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.groupInput.Location = new System.Drawing.Point(24, 181);
            this.groupInput.Name = "groupInput";
            this.groupInput.Size = new System.Drawing.Size(256, 112);
            this.groupInput.TabIndex = 19;
            this.groupInput.TabStop = false;
            this.groupInput.Text = "External Inputs";
            // 
            // label14
            // 
            this.label14.Font = new System.Drawing.Font("Microsoft Sans Serif", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label14.Location = new System.Drawing.Point(84, 83);
            this.label14.Name = "label14";
            this.label14.Size = new System.Drawing.Size(40, 16);
            this.label14.TabIndex = 29;
            this.label14.Text = "Value:";
            // 
            // Label7
            // 
            this.Label7.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.Label7.Location = new System.Drawing.Point(24, 24);
            this.Label7.Name = "Label7";
            this.Label7.Size = new System.Drawing.Size(32, 16);
            this.Label7.TabIndex = 27;
            this.Label7.Text = "Pin 3";
            // 
            // Label6
            // 
            this.Label6.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.Label6.Location = new System.Drawing.Point(83, 24);
            this.Label6.Name = "Label6";
            this.Label6.Size = new System.Drawing.Size(32, 16);
            this.Label6.TabIndex = 26;
            this.Label6.Text = "Pin 2";
            // 
            // Label2
            // 
            this.Label2.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.Label2.Location = new System.Drawing.Point(142, 24);
            this.Label2.Name = "Label2";
            this.Label2.Size = new System.Drawing.Size(32, 16);
            this.Label2.TabIndex = 25;
            this.Label2.Text = "Pin 1";
            // 
            // Label1
            // 
            this.Label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.Label1.Location = new System.Drawing.Point(201, 24);
            this.Label1.Name = "Label1";
            this.Label1.Size = new System.Drawing.Size(32, 16);
            this.Label1.TabIndex = 24;
            this.Label1.Text = "Pin 0";
            // 
            // chkInput2
            // 
            this.chkInput2.Appearance = System.Windows.Forms.Appearance.Button;
            this.chkInput2.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.chkInput2.Enabled = false;
            this.chkInput2.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(64)))), ((int)(((byte)(0)))), ((int)(((byte)(64)))));
            this.chkInput2.Location = new System.Drawing.Point(83, 40);
            this.chkInput2.Name = "chkInput2";
            this.chkInput2.Size = new System.Drawing.Size(24, 24);
            this.chkInput2.TabIndex = 16;
            this.chkInput2.Text = "0";
            this.chkInput2.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.chkInput2.UseVisualStyleBackColor = false;
            // 
            // chkInput0
            // 
            this.chkInput0.Appearance = System.Windows.Forms.Appearance.Button;
            this.chkInput0.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.chkInput0.Enabled = false;
            this.chkInput0.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(64)))), ((int)(((byte)(0)))), ((int)(((byte)(64)))));
            this.chkInput0.Location = new System.Drawing.Point(201, 40);
            this.chkInput0.Name = "chkInput0";
            this.chkInput0.Size = new System.Drawing.Size(24, 24);
            this.chkInput0.TabIndex = 14;
            this.chkInput0.Text = "0";
            this.chkInput0.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.chkInput0.UseVisualStyleBackColor = false;
            // 
            // chkInput3
            // 
            this.chkInput3.Appearance = System.Windows.Forms.Appearance.Button;
            this.chkInput3.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.chkInput3.Enabled = false;
            this.chkInput3.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(64)))), ((int)(((byte)(0)))), ((int)(((byte)(64)))));
            this.chkInput3.Location = new System.Drawing.Point(24, 40);
            this.chkInput3.Name = "chkInput3";
            this.chkInput3.Size = new System.Drawing.Size(24, 24);
            this.chkInput3.TabIndex = 17;
            this.chkInput3.Text = "0";
            this.chkInput3.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.chkInput3.UseVisualStyleBackColor = false;
            // 
            // chkInput1
            // 
            this.chkInput1.Appearance = System.Windows.Forms.Appearance.Button;
            this.chkInput1.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.chkInput1.Enabled = false;
            this.chkInput1.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(64)))), ((int)(((byte)(0)))), ((int)(((byte)(64)))));
            this.chkInput1.Location = new System.Drawing.Point(142, 40);
            this.chkInput1.Name = "chkInput1";
            this.chkInput1.Size = new System.Drawing.Size(24, 24);
            this.chkInput1.TabIndex = 15;
            this.chkInput1.Text = "0";
            this.chkInput1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.chkInput1.UseVisualStyleBackColor = false;
            // 
            // lblInput
            // 
            this.lblInput.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblInput.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.lblInput.Location = new System.Drawing.Point(126, 83);
            this.lblInput.Name = "lblInput";
            this.lblInput.Size = new System.Drawing.Size(40, 16);
            this.lblInput.TabIndex = 19;
            this.lblInput.Text = "0";
            this.lblInput.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // grpConnection
            // 
            this.grpConnection.BackColor = System.Drawing.SystemColors.ControlText;
            this.grpConnection.Controls.Add(this.rdoSerial);
            this.grpConnection.Controls.Add(this.rdoTCP);
            this.grpConnection.Controls.Add(this.udRequestTimeout);
            this.grpConnection.Controls.Add(this.label5);
            this.grpConnection.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.grpConnection.Location = new System.Drawing.Point(224, 80);
            this.grpConnection.Name = "grpConnection";
            this.grpConnection.Size = new System.Drawing.Size(128, 69);
            this.grpConnection.TabIndex = 25;
            this.grpConnection.TabStop = false;
            this.grpConnection.Text = "Connection";
            // 
            // rdoSerial
            // 
            this.rdoSerial.BackColor = System.Drawing.SystemColors.ControlText;
            this.rdoSerial.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.rdoSerial.Location = new System.Drawing.Point(16, 19);
            this.rdoSerial.Name = "rdoSerial";
            this.rdoSerial.Size = new System.Drawing.Size(56, 21);
            this.rdoSerial.TabIndex = 1;
            this.rdoSerial.Text = "Seria&l";
            this.rdoSerial.UseVisualStyleBackColor = false;
            this.rdoSerial.CheckedChanged += new System.EventHandler(this.rdoSerial_CheckedChanged);
            // 
            // rdoTCP
            // 
            this.rdoTCP.BackColor = System.Drawing.SystemColors.ControlText;
            this.rdoTCP.Checked = true;
            this.rdoTCP.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.rdoTCP.Location = new System.Drawing.Point(80, 19);
            this.rdoTCP.Name = "rdoTCP";
            this.rdoTCP.Size = new System.Drawing.Size(46, 21);
            this.rdoTCP.TabIndex = 0;
            this.rdoTCP.TabStop = true;
            this.rdoTCP.Text = "TC&P";
            this.rdoTCP.UseVisualStyleBackColor = false;
            this.rdoTCP.CheckedChanged += new System.EventHandler(this.rdoTCP_CheckedChanged);
            // 
            // udRequestTimeout
            // 
            this.udRequestTimeout.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.udRequestTimeout.Increment = new decimal(new int[] {
            100,
            0,
            0,
            0});
            this.udRequestTimeout.Location = new System.Drawing.Point(47, 41);
            this.udRequestTimeout.Maximum = new decimal(new int[] {
            2147483647,
            0,
            0,
            0});
            this.udRequestTimeout.Minimum = new decimal(new int[] {
            60000,
            0,
            0,
            0});
            this.udRequestTimeout.Name = "udRequestTimeout";
            this.udRequestTimeout.Size = new System.Drawing.Size(68, 18);
            this.udRequestTimeout.TabIndex = 8;
            this.udRequestTimeout.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.udRequestTimeout.ThousandsSeparator = true;
            this.udRequestTimeout.Value = new decimal(new int[] {
            60000,
            0,
            0,
            0});
            // 
            // label5
            // 
            this.label5.Font = new System.Drawing.Font("Microsoft Sans Serif", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label5.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label5.Location = new System.Drawing.Point(6, 43);
            this.label5.Name = "label5";
            this.label5.Size = new System.Drawing.Size(72, 17);
            this.label5.TabIndex = 6;
            this.label5.Text = "Timeout:";
            // 
            // grpNetwork
            // 
            this.grpNetwork.Controls.Add(this.textBox1);
            this.grpNetwork.Controls.Add(this.label3);
            this.grpNetwork.Controls.Add(this.PortUD);
            this.grpNetwork.Controls.Add(this.label4);
            this.grpNetwork.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.grpNetwork.Location = new System.Drawing.Point(358, 58);
            this.grpNetwork.Name = "grpNetwork";
            this.grpNetwork.Size = new System.Drawing.Size(194, 100);
            this.grpNetwork.TabIndex = 26;
            this.grpNetwork.TabStop = false;
            this.grpNetwork.Text = "Network Settings";
            // 
            // textBox1
            // 
            this.textBox1.Location = new System.Drawing.Point(88, 25);
            this.textBox1.Name = "textBox1";
            this.textBox1.Size = new System.Drawing.Size(87, 20);
            this.textBox1.TabIndex = 10;
            this.textBox1.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            // 
            // label3
            // 
            this.label3.Location = new System.Drawing.Point(16, 27);
            this.label3.Name = "label3";
            this.label3.Size = new System.Drawing.Size(80, 20);
            this.label3.TabIndex = 9;
            this.label3.Text = "IP Address:";
            // 
            // PortUD
            // 
            this.PortUD.Location = new System.Drawing.Point(87, 51);
            this.PortUD.Maximum = new decimal(new int[] {
            10000,
            0,
            0,
            0});
            this.PortUD.Name = "PortUD";
            this.PortUD.Size = new System.Drawing.Size(88, 20);
            this.PortUD.TabIndex = 8;
            this.PortUD.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.PortUD.Value = new decimal(new int[] {
            23,
            0,
            0,
            0});
            // 
            // label4
            // 
            this.label4.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label4.Location = new System.Drawing.Point(15, 54);
            this.label4.Name = "label4";
            this.label4.Size = new System.Drawing.Size(67, 20);
            this.label4.TabIndex = 6;
            this.label4.Text = "Telnet Port:";
            // 
            // grpSerial
            // 
            this.grpSerial.Controls.Add(this.cboHostBaudRate);
            this.grpSerial.Controls.Add(this.label16);
            this.grpSerial.Controls.Add(this.cboSerialPorts);
            this.grpSerial.Controls.Add(this.label8);
            this.grpSerial.Enabled = false;
            this.grpSerial.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.grpSerial.Location = new System.Drawing.Point(24, 58);
            this.grpSerial.Name = "grpSerial";
            this.grpSerial.Size = new System.Drawing.Size(194, 100);
            this.grpSerial.TabIndex = 27;
            this.grpSerial.TabStop = false;
            this.grpSerial.Text = "Com Port";
            // 
            // cboHostBaudRate
            // 
            this.cboHostBaudRate.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cboHostBaudRate.Items.AddRange(new object[] {
            "115200",
            "57600",
            "38400",
            "19200",
            "9600"});
            this.cboHostBaudRate.Location = new System.Drawing.Point(112, 50);
            this.cboHostBaudRate.Name = "cboHostBaudRate";
            this.cboHostBaudRate.Size = new System.Drawing.Size(64, 21);
            this.cboHostBaudRate.TabIndex = 19;
            this.cboHostBaudRate.SelectedIndexChanged += new System.EventHandler(this.cboHostBaudRate_SelectedIndexChanged);
            // 
            // label16
            // 
            this.label16.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label16.Location = new System.Drawing.Point(24, 51);
            this.label16.Name = "label16";
            this.label16.Size = new System.Drawing.Size(100, 18);
            this.label16.TabIndex = 20;
            this.label16.Text = "Host Baud Rate:";
            // 
            // cboSerialPorts
            // 
            this.cboSerialPorts.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cboSerialPorts.Items.AddRange(new object[] {
            "COM1:",
            "COM2:",
            "COM3:",
            "COM4:",
            "COM5:",
            "COM6:",
            "COM7:",
            "COM8:",
            "COM9:"});
            this.cboSerialPorts.Location = new System.Drawing.Point(112, 23);
            this.cboSerialPorts.Name = "cboSerialPorts";
            this.cboSerialPorts.Size = new System.Drawing.Size(64, 21);
            this.cboSerialPorts.TabIndex = 13;
            this.cboSerialPorts.SelectedIndexChanged += new System.EventHandler(this.cboSerialPorts_SelectedIndexChanged);
            // 
            // label8
            // 
            this.label8.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.label8.Location = new System.Drawing.Point(24, 26);
            this.label8.Name = "label8";
            this.label8.Size = new System.Drawing.Size(72, 20);
            this.label8.TabIndex = 14;
            this.label8.Text = "Port Name:";
            // 
            // grpStatus
            // 
            this.grpStatus.Controls.Add(this.lblStatus);
            this.grpStatus.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.grpStatus.Location = new System.Drawing.Point(24, 308);
            this.grpStatus.Name = "grpStatus";
            this.grpStatus.Size = new System.Drawing.Size(528, 48);
            this.grpStatus.TabIndex = 28;
            this.grpStatus.TabStop = false;
            this.grpStatus.Text = "Status:";
            // 
            // lblStatus
            // 
            this.lblStatus.ForeColor = System.Drawing.Color.FromArgb(((int)(((byte)(255)))), ((int)(((byte)(255)))), ((int)(((byte)(192)))));
            this.lblStatus.Location = new System.Drawing.Point(16, 20);
            this.lblStatus.Name = "lblStatus";
            this.lblStatus.Size = new System.Drawing.Size(488, 19);
            this.lblStatus.TabIndex = 7;
            this.lblStatus.TextAlign = System.Drawing.ContentAlignment.TopCenter;
            // 
            // timer1
            // 
            this.timer1.Tick += new System.EventHandler(this.timer1_Tick);
            // 
            // Label15
            // 
            this.Label15.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.Label15.ForeColor = System.Drawing.Color.Yellow;
            this.Label15.Location = new System.Drawing.Point(17, 16);
            this.Label15.Name = "Label15";
            this.Label15.Size = new System.Drawing.Size(536, 23);
            this.Label15.TabIndex = 38;
            this.Label15.Text = "This application requires an IO device connected to the IO port of the reader.";
            this.Label15.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.BackColor = System.Drawing.SystemColors.ControlText;
            this.ClientSize = new System.Drawing.Size(568, 382);
            this.Controls.Add(this.Label15);
            this.Controls.Add(this.grpStatus);
            this.Controls.Add(this.grpSerial);
            this.Controls.Add(this.grpNetwork);
            this.Controls.Add(this.grpConnection);
            this.Controls.Add(this.groupInput);
            this.Controls.Add(this.btnDisconnect);
            this.Controls.Add(this.btnConnect);
            this.Controls.Add(this.groupOutput);
            this.Name = "Form1";
            this.Text = "Form1";
            this.Load += new System.EventHandler(this.Form1_Load);
            this.Closing += new System.ComponentModel.CancelEventHandler(this.Form1_Closing);
            this.groupOutput.ResumeLayout(false);
            this.groupInput.ResumeLayout(false);
            this.grpConnection.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.udRequestTimeout)).EndInit();
            this.grpNetwork.ResumeLayout(false);
            this.grpNetwork.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.PortUD)).EndInit();
            this.grpSerial.ResumeLayout(false);
            this.grpStatus.ResumeLayout(false);
            this.ResumeLayout(false);

		}

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
				Application.Run(new Form1());
		}

		#endregion


		private void Form1_Load(object sender, System.EventArgs e)
		{
			try
			{
                string exePath = Application.ExecutablePath;
                int idx = exePath.LastIndexOf("\\");
                if (idx != -1)
                    AlienLog.Path = exePath.Substring(0, idx + 1);
                AlienLog.WriteLine(true, "Starting the 'Ex8-Digital IO' application.");

                mReader = new clsReader(true);

                mReaderInfo = new ReaderInfo();
				this.Text = "Alien Library .NET - Testing Digital IO in C#";

				Thread.CurrentThread.Name = "Alien-Ex.8: Test Digital IO in C#";
			}
			catch(Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
			ManageGUI(false);
		}

		private void Form1_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if (mReader != null)
			{
				mReader.Dispose();
			}
		}


		private void btnConnect_Click(object sender, System.EventArgs e)
		{		//Connect
			String result;
			this.Cursor = Cursors.WaitCursor;
			try		// extra precausion though it shouldn't throw exceptions
			{
				if (meReaderInterface == ComInterface.enumTCPIP)
					mReader.InitOnNetwork(textBox1.Text, Convert.ToInt32(PortUD.Value));
				else
					mReader.InitOnCom();

				lblStatus.Text = "Connecting to the reader...";
				this.Cursor = Cursors.WaitCursor;
				mReader.ComTimeOutInterval = (int)udRequestTimeout.Value;

				result = mReader.Connect();
				if (!mReader.IsConnected)
				{
					lblStatus.Text = "Can't connect";
				}
				else
				{
					lblStatus.Text = "Connected";
					timer1.Enabled = true;

					if (meReaderInterface == ComInterface.enumTCPIP)
					{
						lblStatus.Text = "Logging in...";
						this.Cursor = Cursors.WaitCursor;
						if (!mReader.Login("alien", "password"))		//returns result synchronously
						{
							lblStatus.Text = "Login failed! Calling Disconnect()...";
							mReader.Disconnect();
							timer1.Enabled = false;
							return;
						}
						lblStatus.Text = "Logged in - OK!";
					}
				}
			}
			catch(Exception ex)
			{
				MessageBox.Show(ex.Message);
			}
			ManageGUI(mReader.IsConnected);
			this.Cursor = Cursors.Default;
		}

		private void btnDisconnect_Click(object sender, System.EventArgs e)
		{		//Disconnect
			if (mReader.IsConnected)
			{
				mReader.Disconnect();
				lblStatus.Text = "Disconnected";
				timer1.Enabled = false;
			}	
			else
				lblStatus.Text = "Not Connected";

			ManageGUI(mReader.IsConnected);

		}

		private void ManageGUI(bool connected)
		{
			btnConnect.Enabled = !connected;
			btnDisconnect.Enabled = connected;
			groupInput.Enabled = connected;
			groupOutput.Enabled = connected;
			grpConnection.Enabled = !connected;
			timer1.Enabled = connected;
		}
		
		
		private void cboSerialPorts_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (cboSerialPorts.Text != "")
				mReader.SerialPort = cboSerialPorts.Text;
		}


		private void rdoSerial_CheckedChanged(object sender, System.EventArgs e)
		{
			bool state = rdoSerial.Checked;
			grpSerial.Enabled = state;
			grpNetwork.Enabled = !state;
			btnConnect.Text = (state ? "Co&nnect" : "Co&nnect + Login");
			meReaderInterface = (state ? ComInterface.enumSerial : ComInterface.enumTCPIP);
			mReaderInfo.InterfaceType = meReaderInterface;
			mReader.ReaderSettings = mReaderInfo;
		
		}

		private void rdoTCP_CheckedChanged(object sender, System.EventArgs e)
		{
			bool state = rdoTCP.Checked;
			grpSerial.Enabled = !state;
			grpNetwork.Enabled = state;
			btnConnect.Text = (state ? "Co&nnect + Login" : "Co&nnect" );
			meReaderInterface = (state ? ComInterface.enumTCPIP : ComInterface.enumSerial);
			mReaderInfo.InterfaceType = meReaderInterface;
			mReader.ReaderSettings = mReaderInfo;
		}


		private void chkOutputs_CheckedChanged(object sender, System.EventArgs e)
		{
			CheckBox chkBox = (CheckBox)sender;
			if (chkBox.Checked)
			{
				chkBox.Text = "1";
				chkBox.BackColor = System.Drawing.Color.FromArgb(((System.Byte)(128)), ((System.Byte)(255)), ((System.Byte)(128)));
			}
			else
			{
				chkBox.Text = "0";
				chkBox.BackColor = System.Drawing.Color.FromArgb(((System.Byte)(255)), ((System.Byte)(255)), ((System.Byte)(192)));
			}
			SetExternalOutputs();
		}

		private void timer1_Tick(object sender, System.EventArgs e)
		{
			timer1.Enabled = false;

			try
			{
				mInputValue = int.Parse(mReader.ExternalInput);
				ShowExternalInputs(mInputValue);
				mReader.ExternalOutput = mOutputValue.ToString();
				lblInput.Text = mInputValue.ToString();
				lblOutput.Text = mOutputValue.ToString();
			}
			catch(Exception ex)
			{
				lblStatus.Text = ex.Message;
			}

			if (mReader.IsConnected)
				timer1.Enabled = true;
		}	

		
		private void SetExternalOutputs()
		{
			int i = 0;
		    
			if (chkOutput0.Checked)
				i++;
			if (chkOutput1.Checked)
				i += 2;		    
			if (chkOutput2.Checked)
				i += 4;		    
			if (chkOutput3.Checked)
				i += 8;
		         
			mOutputValue = i;
		}

		private void ShowExternalInputs(int n)
		{
			SetCheckbox (chkInput0, (n & 1) != 0);
			SetCheckbox (chkInput1, (n & 2) != 0);
			SetCheckbox (chkInput2, (n & 4) != 0);
			SetCheckbox (chkInput3, (n & 8) != 0);
		}

		private void SetCheckbox(CheckBox box, bool b)
		{
			if (b)
			{
				box.Checked = true;
				box.Text = "1";
				box.BackColor = System.Drawing.Color.FromArgb(((System.Byte)(128)), ((System.Byte)(255)), ((System.Byte)(128)));
			}
			else
			{
				box.Checked = false;
				box.Text = "0";
				box.BackColor = System.Drawing.Color.FromArgb(((System.Byte)(255)), ((System.Byte)(255)), ((System.Byte)(192)));
			}
		}

		private void cboHostBaudRate_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			try
			{
				mReader.HostBaudRate = int.Parse(cboHostBaudRate.Text);
			}
			catch (Exception ex)
			{
				lblStatus.Text = ex.Message;
			}
		}
	}
}
